﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class MainForm

    ''' <summary>
    ''' 隐藏主窗体，因为以任务栏图标形式运行的程序通常没有
    ''' 可见窗体。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnTray_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnTray.Click
        Me.Hide()
        NotifyIcon1.Visible = True
        NotifyIcon1.Text = "System Information"
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' 在用户单击“开始”前，确保不出现任务栏图标。
        ' 否则任务栏图标会与主窗体同时可见。
        NotifyIcon1.Visible = False
    End Sub

    ''' <summary>
    ''' 获取操作系统信息。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub osMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles osMenuItem.Click
        MsgBox(My.Computer.Info.OSFullName & vbCrLf & "Version " & My.Computer.Info.OSVersion)
    End Sub

    ''' <summary>
    ''' 显示当前日期。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub currentDateMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles currentDateMenuItem.Click
        MsgBox("Today's date is " & My.Computer.Clock.LocalTime.ToLongDateString & ".")
    End Sub

    ''' <summary>
    ''' 使用 TimeZone 类显示用户的当前时区的名称。 
    ''' TimeZone 类还可用来确定用户的位置
    ''' 当前是否使用夏时制时间，以及给定时区的 
    ''' 夏时制时间的生效时间。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub timeZoneMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles timeZoneMenuItem.Click
        If (TimeZone.CurrentTimeZone.IsDaylightSavingTime(DateTime.Now)) Then
            MsgBox("The current time zone is: " & TimeZone.CurrentTimeZone.DaylightName & ".")
        Else
            MsgBox("The current time zone is: " & TimeZone.CurrentTimeZone.StandardName & ".")
        End If
    End Sub


    ''' <summary>
    ''' 获取当前 .NET Framework 版本。输出内部版本、主版本和
    ''' 次版本信息。还可以通过属性单独访问
    ''' 这些信息。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub frameworkMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles frameworkMenuItem.Click
        MsgBox("Framework Version: " & Environment.Version.ToString() & ".")
    End Sub

    ''' <summary>
    ''' 显示自计算机上次重新启动以来的运行时间。
    ''' 从 TickCount 检索到的时间以毫秒为单位。此单位会转换为分钟。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub restartMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles restartMenuItem.Click
        Dim timeSinceLastRebootMinutes As Double = My.Computer.Clock.TickCount / 1000 / 60
        MsgBox("It has been " & CInt(timeSinceLastRebootMinutes).ToString() & " minutes since your last reboot.")
    End Sub

    ''' <summary>
    ''' 当用户双击任务栏图标时，再次显示主窗体。
    ''' 同样，在窗体可见期间使任务栏图标消失。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ntfSystemInfo_DoubleClick(ByVal sender As Object, ByVal e As System.EventArgs) Handles NotifyIcon1.DoubleClick
        NotifyIcon1.Visible = False
        Me.Show()
    End Sub

    Protected Sub Shutdown()
        ' 最好使系统任务栏图标在结束应用程序前
        ' 不可见，否则当应用程序不再运行时，
        ' 它还会逗留在任务栏中。
        NotifyIcon1.Visible = False
        Application.Exit()
    End Sub

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Shutdown()
    End Sub

    Private Sub exitMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitMenuItem.Click
        Shutdown()
    End Sub
End Class
